function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
% function g1 = dynamic_g1(T, y, x, params, steady_state, it_, T_flag)
%
% File created by Dynare Preprocessor from .mod file
%
% Inputs:
%   T             [#temp variables by 1]     double   vector of temporary terms to be filled by function
%   y             [#dynamic variables by 1]  double   vector of endogenous variables in the order stored
%                                                     in M_.lead_lag_incidence; see the Manual
%   x             [nperiods by M_.exo_nbr]   double   matrix of exogenous variables (in declaration order)
%                                                     for all simulation periods
%   steady_state  [M_.endo_nbr by 1]         double   vector of steady state values
%   params        [M_.param_nbr by 1]        double   vector of parameter values in declaration order
%   it_           scalar                     double   time period for exogenous variables for which
%                                                     to evaluate the model
%   T_flag        boolean                    boolean  flag saying whether or not to calculate temporary terms
%
% Output:
%   g1
%

if T_flag
    T = World_Economy_Cartel_Fracking_IRF.dynamic_g1_tt(T, y, x, params, steady_state, it_);
end
g1 = zeros(76, 140);
g1(1,26)=T(32)+T(36);
g1(1,29)=T(32);
g1(1,11)=T(34);
g1(1,43)=exp(y(26))*exp(y(29))*T(78);
g1(1,44)=T(112);
g1(1,47)=T(113);
g1(1,54)=T(35);
g1(1,65)=exp(y(26));
g1(1,20)=T(33)*(-(T(24)*exp(y(26))*exp(y(11))));
g1(1,22)=T(33)*(-(exp(y(26))*T(24)));
g1(1,23)=T(233);
g1(1,79)=(-exp(y(26)));
g1(1,93)=(-1);
g1(1,132)=params(25);
g1(2,27)=T(26)*(-exp(y(27)))+exp(y(27))*y(69)+y(85)*(-(T(31)*params(4)*params(4)*exp(y(27)*params(4))));
g1(2,43)=(-exp(y(27)))*T(78);
g1(2,44)=(-exp(y(27)))*T(91);
g1(2,69)=exp(y(27));
g1(2,85)=(-(T(31)*params(4)*exp(y(27)*params(4))));
g1(2,95)=(-1);
g1(2,134)=params(25);
g1(3,28)=y(83)*(-(T(29)*params(4)*params(4)*exp(y(28)*params(4))))+exp(y(28))*y(69)+y(74)*y(39)*T(29)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(28)*(params(4)-1));
g1(3,39)=y(74)*T(29)*params(4)*(params(4)-1)*exp(y(28)*(params(4)-1));
g1(3,69)=exp(y(28));
g1(3,74)=y(39)*T(29)*params(4)*(params(4)-1)*exp(y(28)*(params(4)-1));
g1(3,83)=(-(T(29)*params(4)*exp(y(28)*params(4))));
g1(3,94)=(-1);
g1(3,133)=params(25);
g1(4,26)=T(32);
g1(4,29)=T(26)*T(37)+y(89)*(-exp(y(29)))+exp(y(29))*y(88);
g1(4,43)=T(37)*T(78);
g1(4,44)=T(37)*T(91);
g1(4,49)=T(102);
g1(4,63)=T(26)*T(111);
g1(4,88)=exp(y(29));
g1(4,89)=(-exp(y(29)));
g1(4,97)=(-1);
g1(4,136)=params(25);
g1(5,30)=y(89)*(-exp(y(30)))+exp(y(30))*y(86);
g1(5,86)=exp(y(30));
g1(5,89)=(-exp(y(30)));
g1(5,96)=(-1);
g1(5,135)=params(25);
g1(6,31)=T(39);
g1(6,35)=T(45);
g1(6,111)=T(225);
g1(6,119)=params(25)*exp(y(31))*params(6)*exp(params(5)*y(35));
g1(6,82)=exp(y(31));
g1(6,123)=params(25)*(-(exp(y(31))*(1-exp((-y(111)))*exp(y(35)))));
g1(6,129)=T(236);
g1(7,32)=T(41);
g1(7,36)=T(116);
g1(7,119)=params(25)*params(6)*exp(params(5)*y(36))*exp(y(32));
g1(7,80)=exp(y(32));
g1(7,121)=params(25)*(-((1-exp(y(36)))*exp(y(32))));
g1(7,127)=params(25)*(-(exp(y(36))*exp(y(32))));
g1(8,33)=T(42);
g1(8,82)=(-(params(7)*exp(y(33))));
g1(8,85)=exp(y(33));
g1(8,126)=params(25)*(-((1-params(7))*exp(y(33))));
g1(9,34)=T(43);
g1(9,80)=(-(params(7)*exp(y(34))));
g1(9,83)=exp(y(34));
g1(9,124)=params(25)*(-((1-params(7))*exp(y(34))));
g1(10,31)=T(45);
g1(10,35)=params(25)*y(131)*(-exp(y(35)))+T(118);
g1(10,111)=T(225);
g1(10,119)=params(25)*exp(y(31))*params(6)*params(5)*exp(params(5)*y(35));
g1(10,123)=T(235);
g1(10,129)=T(236);
g1(10,131)=params(25)*(-exp(y(35)));
g1(11,101)=y(72)*T(114);
g1(11,32)=T(116);
g1(11,36)=T(40)+T(48)+y(75)*T(23)*params(6)*params(5)*(params(5)-1)*(params(5)-1)*exp(y(36)*(params(5)-1))+T(121)+params(25)*y(119)*exp(y(32))*params(6)*params(5)*params(5)*exp(params(5)*y(36));
g1(11,102)=y(72)*(-(T(23)*(-exp(y(36)))));
g1(11,109)=y(75)*T(46)+y(72)*T(47);
g1(11,119)=params(25)*exp(y(32))*params(6)*params(5)*exp(params(5)*y(36));
g1(11,72)=T(47);
g1(11,75)=T(46);
g1(11,121)=params(25)*(-(exp(y(32))*(-exp(y(36)))));
g1(11,127)=params(25)*(-(exp(y(36))*exp(y(32))));
g1(12,37)=exp(y(37))*y(68);
g1(12,68)=exp(y(37));
g1(13,11)=T(33)*y(20)*(-(T(24)*(-exp(y(11)))));
g1(13,47)=T(33)*y(20)*(-(T(24)*(1-exp(y(11)))))+T(33)*T(24)*y(22);
g1(13,20)=T(33)*(-(T(24)*(1-exp(y(11)))));
g1(13,72)=1;
g1(13,73)=(-params(7));
g1(13,22)=T(24)*T(33);
g1(14,28)=y(74)*T(29)*params(4)*(params(4)-1)*exp(y(28)*(params(4)-1));
g1(14,47)=T(33)*y(21)*(-(T(24)*(1-params(7))));
g1(14,21)=T(33)*(-(T(24)*(1-params(7))));
g1(14,73)=1;
g1(14,74)=params(4)*exp(y(28)*(params(4)-1))*T(29);
g1(15,40)=T(8)*y(89)+y(65)*(-(params(11)*T(12)*T(124)))+y(64)*(-(T(51)*T(128)+params(11)*T(50)*params(11)*T(50)*T(129)));
g1(15,41)=y(65)*(-(T(49)*params(11)*T(52)));
g1(15,13)=y(64)*(-(params(11)*T(50)*T(129)*T(144)));
g1(15,43)=y(64)*(-(params(11)*T(50)*T(88)*T(129)));
g1(15,48)=y(64)*(-(params(11)*T(50)*T(98)*T(129)));
g1(15,64)=(-(params(11)*T(50)*T(51)));
g1(15,65)=(-(params(11)*T(12)*T(49)));
g1(15,89)=T(8);
g1(16,40)=y(65)*(-(T(49)*params(11)*T(52)));
g1(16,41)=y(69)*(-exp(y(41)))+y(67)*(-(T(5)*T(19)*T(16)*exp(T(1)*y(48))*(1-params(11))*params(3)*T(134)))+y(66)*(-(T(17)*T(3)*T(16)*exp(T(1)*y(48))*(1-params(11))*(1-params(3))*T(134)))+exp(y(41))*y(64)+y(65)*(-(T(14)*params(11)*T(134)));
g1(16,13)=y(67)*T(146)+y(66)*(-(T(17)*T(147)));
g1(16,43)=T(135);
g1(16,48)=T(138);
g1(16,64)=exp(y(41));
g1(16,65)=(-(T(14)*params(11)*T(52)));
g1(16,66)=(-(T(17)*T(3)*T(16)*T(54)));
g1(16,67)=(-(T(5)*T(19)*T(16)*T(53)));
g1(16,69)=(-exp(y(41)));
g1(16,98)=(-1);
g1(16,137)=params(25);
g1(17,104)=params(25)*y(115)*(-(T(61)*params(11)*T(130)*T(131)));
g1(17,105)=params(25)*y(116)*(-(T(65)*(T(57)*T(68)*T(140)+T(58)*T(70)*T(140))))+params(25)*y(117)*T(141);
g1(17,42)=T(20)*y(69)+params(25)*y(119)*(-(T(20)*(1-params(10))))+params(25)*y(115)*(-(T(64)*T(160)+T(61)*T(61)*T(131)))+params(25)*y(116)*(-(T(65)*(T(67)*T(68)*T(158)+T(57)*T(67)*T(70)+T(57)*T(67)*T(70)+T(58)*T(67)*T(162))))+params(25)*y(117)*(-(T(56)*(T(70)*T(72)*T(73)+T(71)*T(72)*T(162)+T(70)*T(72)*T(73)+T(68)*T(72)*T(165))))+params(25)*y(118)*(-(exp((1-params(3))*y(106))*exp(T(1)*y(110))*params(3)*params(3)*exp(params(3)*y(42))));
g1(17,106)=params(25)*y(115)*(-(T(64)*T(198)+T(61)*T(131)*T(55)*T(60)*T(58)*T(197)))+params(25)*y(116)*(-((T(57)*T(67)*T(68)+T(58)*T(67)*T(70))*T(199)+T(65)*(T(57)*T(67)*T(69)*T(58)*T(197)+T(58)*T(67)*T(200))))+params(25)*y(117)*(-((T(71)*T(70)*T(72)+T(68)*T(72)*T(73))*T(197)+T(56)*(T(71)*T(72)*T(200)+T(73)*T(72)*T(69)*T(58)*T(197))))+params(25)*y(118)*(-(exp(T(1)*y(110))*params(3)*exp(params(3)*y(42))*(1-params(3))*exp((1-params(3))*y(106))));
g1(17,110)=params(25)*y(115)*(-(T(64)*T(217)+T(61)*T(131)*T(62)*(1-params(11))*T(1)*exp(T(1)*y(110))))+params(25)*y(116)*(-(T(65)*T(219)))+params(25)*y(117)*(-(T(56)*T(220)))+params(25)*y(118)*(-(exp((1-params(3))*y(106))*params(3)*exp(params(3)*y(42))*T(1)*exp(T(1)*y(110))));
g1(17,115)=params(25)*(-(T(61)*T(64)));
g1(17,116)=params(25)*(-(T(65)*(T(57)*T(67)*T(68)+T(58)*T(67)*T(70))));
g1(17,117)=params(25)*T(74);
g1(17,118)=params(25)*(-(exp((1-params(3))*y(106))*exp(T(1)*y(110))*params(3)*exp(params(3)*y(42))));
g1(17,69)=T(20);
g1(17,119)=params(25)*(-(T(20)*(1-params(10))));
g1(18,26)=exp(y(26))*exp(y(29))*T(78);
g1(18,27)=(-exp(y(27)))*T(78);
g1(18,29)=T(37)*T(78);
g1(18,40)=y(64)*(-(T(88)*params(11)*T(50)*T(129)));
g1(18,41)=T(135);
g1(18,13)=y(68)*(-(T(79)*exp(T(1)*y(48))*params(3)*exp(y(13)*params(3))))+y(67)*(-(T(81)*(T(19)*T(18)*T(82)*T(143)+T(16)*T(18)*T(145))+T(5)*(T(18)*T(83)*T(145)+T(19)*T(18)*T(149))))+y(66)*(-(T(17)*(T(15)*T(83)*T(142)+T(3)*T(15)*T(149))+T(85)*T(150)))+y(64)*(-(T(88)*T(129)*T(144)+T(51)*T(152)));
g1(18,14)=y(71)*T(170);
g1(18,43)=(T(37)-exp(y(27)))*T(177)+y(71)*(-(params(1)*T(177)/T(28)))+T(4)*y(70)+y(68)*(-(exp(T(1)*y(48))*exp(y(13)*params(3))*(1-params(3))*T(79)))+y(67)*T(182)+y(66)*T(186)+y(64)*(-(T(88)*T(88)*T(129)+T(51)*T(187)))+params(25)*y(120)*T(189);
g1(18,106)=params(25)*y(120)*(-((-(T(78)*T(204)))/(T(26)*T(26))));
g1(18,15)=y(71)*T(205);
g1(18,44)=(T(37)-exp(y(27)))*T(207)+y(71)*(-(params(1)*T(207)/T(28)))+params(25)*y(120)*T(209);
g1(18,107)=params(25)*y(120)*(-((-(T(78)*params(1)*exp(y(107))*T(203)))/(T(26)*T(26))));
g1(18,48)=y(68)*(-(T(79)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(48))))+T(193)+T(194)+y(64)*(-(T(51)*T(195)+T(88)*T(98)*T(129)));
g1(18,49)=T(196);
g1(18,63)=T(78)*T(111);
g1(18,64)=(-(T(51)*T(88)));
g1(18,66)=T(86);
g1(18,67)=T(84);
g1(18,68)=T(80);
g1(18,70)=T(4);
g1(18,71)=(-(params(1)*T(78)/T(28)));
g1(18,120)=params(25)*(-((-(T(78)*T(90)))/(T(26)*T(26))));
g1(19,26)=T(112);
g1(19,27)=(-exp(y(27)))*T(91);
g1(19,29)=T(37)*T(91);
g1(19,14)=y(71)*T(171);
g1(19,43)=(T(37)-exp(y(27)))*T(190)+y(71)*(-(params(1)*T(190)/T(28)))+params(25)*y(120)*(-(T(191)/T(188)));
g1(19,106)=params(25)*y(120)*(-((-(T(91)*T(204)))/(T(26)*T(26))));
g1(19,15)=y(71)*T(206);
g1(19,44)=(T(37)-exp(y(27)))*T(210)+y(71)*(-(params(1)*T(210)/T(28)))+exp(y(44))*y(69)+params(25)*y(120)*(-((T(26)*T(26)*(-(T(90)*T(210)))-(-(T(90)*T(91)))*T(208))/T(188)));
g1(19,107)=params(25)*y(120)*(-((-(T(91)*params(1)*exp(y(107))*T(203)))/(T(26)*T(26))));
g1(19,49)=T(91)*T(101);
g1(19,63)=T(91)*T(111);
g1(19,69)=exp(y(44));
g1(19,71)=T(92);
g1(19,120)=params(25)*(-((-(T(90)*T(91)))/(T(26)*T(26))));
g1(20,45)=exp(y(45))*y(67)+T(33)*y(19)*(-(exp(y(45))*T(24)));
g1(20,47)=T(33)*y(19)*(-(exp(y(45))*T(24)));
g1(20,67)=exp(y(45));
g1(20,19)=T(33)*(-(exp(y(45))*T(24)));
g1(21,46)=exp(y(46))*y(66)+y(70)*(-(T(21)*T(213)));
g1(21,66)=exp(y(46));
g1(21,70)=(-(T(21)*T(93)));
g1(22,26)=T(113);
g1(22,11)=T(119);
g1(22,38)=T(33)*y(20)*(-(T(24)*(1-exp(y(11)))))+T(33)*T(24)*y(22);
g1(22,39)=T(33)*y(21)*(-(T(24)*(1-params(7))));
g1(22,45)=T(33)*y(19)*(-(exp(y(45))*T(24)));
g1(22,47)=T(94);
g1(22,54)=T(110);
g1(22,55)=T(33)*y(23)*(-(T(24)*(1-exp(y(54)))));
g1(22,56)=T(33)*y(24)*(-(T(24)*(1-params(23))));
g1(22,19)=T(33)*(-(T(24)*(1+exp(y(45))-params(10))));
g1(22,71)=T(24);
g1(22,20)=T(33)*(-(T(24)*(exp(y(26))*exp(y(11))+y(38)*(1-exp(y(11)))-params(6)*exp(params(5)*y(11)))));
g1(22,21)=T(33)*(-(y(39)*T(24)*(1-params(7))));
g1(22,22)=T(33)*(T(24)*params(6)*params(5)*exp(y(11)*(params(5)-1))-T(24)*(exp(y(26))-y(38)));
g1(22,23)=T(33)*(-(T(24)*(exp(y(26))*exp(y(54))+y(55)*(1-exp(y(54)))-params(22)*exp(params(21)*y(54)))));
g1(22,24)=T(33)*(-(y(56)*T(24)*(1-params(23))));
g1(23,40)=y(64)*(-(T(98)*params(11)*T(50)*T(129)));
g1(23,41)=T(138);
g1(23,13)=y(68)*T(153)+y(67)*(-(T(5)*T(154)))+y(66)*(-(T(17)*T(155)))+y(64)*(-(T(98)*T(129)*T(144)+T(51)*T(97)*T(87)*T(143)));
g1(23,43)=y(68)*(-(T(79)*exp(y(13)*params(3))*T(1)*exp(T(1)*y(48))))+T(193)+T(194)+y(64)*(-(T(98)*T(88)*T(129)+T(51)*T(195)));
g1(23,48)=y(68)*T(214)+y(67)*(-(T(5)*T(19)*T(16)*T(12)*(1-params(11))*params(3)*T(1)*T(1)*exp(T(1)*y(48))))+y(66)*T(215)+y(64)*(-(T(98)*T(98)*T(129)+T(51)*T(216)));
g1(23,64)=(-(T(51)*T(98)));
g1(23,66)=(-(T(17)*T(3)*T(16)*T(96)));
g1(23,67)=(-(T(5)*T(19)*T(16)*T(95)));
g1(23,68)=(-(exp(y(43)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(48))));
g1(23,91)=1;
g1(23,130)=params(25)*(-params(15));
g1(23,138)=T(99)*(-params(16));
g1(24,29)=T(102);
g1(24,6)=T(105);
g1(24,10)=T(105);
g1(24,43)=T(196);
g1(24,44)=T(91)*T(101);
g1(24,49)=T(26)*T(222)+T(223);
g1(24,63)=T(26)*T(231);
g1(24,82)=T(104);
g1(24,88)=T(103);
g1(24,90)=1;
g1(25,50)=y(84)*(-(T(30)*params(4)*params(4)*exp(y(50)*params(4))))+exp(y(50))*y(69)+y(78)*y(56)*T(30)*params(4)*(params(4)-1)*(params(4)-1)*exp(y(50)*(params(4)-1));
g1(25,56)=y(78)*T(30)*params(4)*(params(4)-1)*exp(y(50)*(params(4)-1));
g1(25,69)=exp(y(50));
g1(25,78)=y(56)*T(30)*params(4)*(params(4)-1)*exp(y(50)*(params(4)-1));
g1(25,84)=(-(T(30)*params(4)*exp(y(50)*params(4))));
g1(26,51)=y(89)*(-exp(y(51)))+exp(y(51))*y(87);
g1(26,87)=exp(y(51));
g1(26,89)=(-exp(y(51)));
g1(27,52)=T(106);
g1(27,112)=T(229);
g1(27,119)=params(25)*params(22)*exp(params(21)*y(112))*exp(y(52));
g1(27,81)=exp(y(52));
g1(27,122)=params(25)*(-((1-exp(y(112)))*exp(y(52))));
g1(27,128)=params(25)*(-(exp(y(112))*exp(y(52))));
g1(28,53)=T(107);
g1(28,81)=(-(params(23)*exp(y(53))));
g1(28,84)=exp(y(53));
g1(28,125)=params(25)*(-((1-params(23))*exp(y(53))));
g1(29,26)=T(35);
g1(29,47)=T(110);
g1(29,17)=T(226);
g1(29,54)=y(87)*T(108)+y(81)*T(109)+y(79)*params(22)*params(21)*(params(21)-1)*(params(21)-1)*exp(y(54)*(params(21)-1))+y(69)*exp(y(17))*params(22)*params(21)*params(21)*exp(params(21)*y(54))+T(227);
g1(29,55)=T(228);
g1(29,69)=exp(y(17))*params(22)*params(21)*exp(params(21)*y(54));
g1(29,23)=T(234);
g1(29,79)=params(22)*params(21)*(params(21)-1)*exp(y(54)*(params(21)-1));
g1(29,81)=T(109);
g1(29,87)=T(108);
g1(30,47)=T(33)*y(23)*(-(T(24)*(1-exp(y(54)))));
g1(30,54)=T(228);
g1(30,23)=T(33)*(-(T(24)*(1-exp(y(54)))));
g1(30,76)=1;
g1(30,77)=(-params(23));
g1(30,79)=1;
g1(31,47)=T(33)*y(24)*(-(T(24)*(1-params(23))));
g1(31,50)=y(78)*T(30)*params(4)*(params(4)-1)*exp(y(50)*(params(4)-1));
g1(31,24)=T(33)*(-(T(24)*(1-params(23))));
g1(31,77)=1;
g1(31,78)=params(4)*exp(y(50)*(params(4)-1))*T(30);
g1(32,93)=1;
g1(33,94)=1;
g1(34,95)=1;
g1(35,96)=1;
g1(36,97)=1;
g1(37,98)=1;
g1(38,29)=T(26)*T(111);
g1(38,43)=T(78)*T(111);
g1(38,44)=T(91)*T(111);
g1(38,49)=T(26)*T(224);
g1(38,63)=exp(y(63))*y(92)+T(26)*T(232);
g1(38,92)=exp(y(63));
g1(39,40)=(-(params(11)*T(50)*T(51)));
g1(39,41)=exp(y(41));
g1(39,13)=(-(T(51)*T(144)));
g1(39,43)=(-(T(51)*T(88)));
g1(39,48)=(-(T(51)*T(98)));
g1(40,26)=exp(y(26));
g1(40,40)=(-(params(11)*T(12)*T(49)));
g1(40,41)=(-(T(14)*params(11)*T(52)));
g1(41,41)=(-(T(17)*T(3)*T(16)*T(54)));
g1(41,13)=(-(T(17)*T(150)));
g1(41,43)=T(86);
g1(41,46)=exp(y(46));
g1(41,48)=(-(T(17)*T(3)*T(16)*T(96)));
g1(42,41)=(-(T(5)*T(19)*T(16)*T(53)));
g1(42,13)=(-(T(5)*(T(19)*T(18)*T(82)*T(143)+T(16)*T(18)*T(145))));
g1(42,43)=T(84);
g1(42,45)=exp(y(45));
g1(42,48)=(-(T(5)*T(19)*T(16)*T(95)));
g1(43,37)=exp(y(37));
g1(43,13)=(-(exp(y(43)*(1-params(3)))*exp(T(1)*y(48))*params(3)*exp(y(13)*params(3))));
g1(43,43)=T(80);
g1(43,48)=(-(exp(y(43)*(1-params(3)))*exp(y(13)*params(3))*T(1)*exp(T(1)*y(48))));
g1(44,27)=exp(y(27));
g1(44,28)=exp(y(28));
g1(44,6)=params(6)*exp(params(5)*y(10))*exp(y(6));
g1(44,7)=params(6)*exp(params(5)*y(11))*exp(y(7));
g1(44,10)=exp(y(6))*params(6)*params(5)*exp(params(5)*y(10));
g1(44,11)=exp(y(7))*params(6)*params(5)*exp(params(5)*y(11));
g1(44,41)=(-exp(y(41)));
g1(44,13)=(-(exp(y(13))*(1-params(10))));
g1(44,42)=T(20);
g1(44,44)=exp(y(44));
g1(44,50)=exp(y(50));
g1(44,17)=params(22)*exp(params(21)*y(54))*exp(y(17));
g1(44,54)=exp(y(17))*params(22)*params(21)*exp(params(21)*y(54));
g1(45,43)=T(4);
g1(45,46)=(-(T(21)*T(93)));
g1(46,108)=(-(T(23)*exp(y(108))));
g1(46,109)=(-(T(23)*(1+exp(y(108))-params(10))));
g1(47,14)=(-((-(params(1)*T(26)*T(169)))/(T(28)*T(28))));
g1(47,43)=(-(params(1)*T(78)/T(28)));
g1(47,15)=(-((-(params(1)*T(26)*exp(y(15))*T(168)))/(T(28)*T(28))));
g1(47,44)=T(92);
g1(47,47)=T(24);
g1(48,101)=T(114);
g1(48,36)=T(47);
g1(48,38)=1;
g1(48,102)=(-(T(23)*(1-exp(y(36)))));
g1(48,109)=(-(T(23)*(exp(y(36))*exp(y(101))+(1-exp(y(36)))*y(102)-params(6)*exp(params(5)*y(36)))));
g1(49,38)=(-params(7));
g1(49,39)=1;
g1(49,103)=(-(T(23)*(1-params(7))));
g1(49,109)=(-(T(23)*(1-params(7))*y(103)));
g1(50,28)=y(39)*T(29)*params(4)*(params(4)-1)*exp(y(28)*(params(4)-1));
g1(50,39)=params(4)*exp(y(28)*(params(4)-1))*T(29);
g1(51,101)=(-(T(23)*exp(y(101))));
g1(51,36)=T(46);
g1(51,102)=T(23);
g1(51,109)=T(23)*params(6)*params(5)*exp(y(36)*(params(5)-1))-T(23)*(exp(y(101))-y(102));
g1(52,101)=(-(T(23)*exp(y(101))*exp(y(112))));
g1(52,109)=(-(T(23)*(exp(y(101))*exp(y(112))+(1-exp(y(112)))*y(113)-params(22)*exp(params(21)*y(112)))));
g1(52,112)=(-(T(23)*(exp(y(101))*exp(y(112))+y(113)*(-exp(y(112)))-params(22)*params(21)*exp(params(21)*y(112)))));
g1(52,55)=1;
g1(52,113)=(-(T(23)*(1-exp(y(112)))));
g1(53,109)=(-(T(23)*(1-params(23))*y(114)));
g1(53,55)=(-params(23));
g1(53,56)=1;
g1(53,114)=(-(T(23)*(1-params(23))));
g1(54,50)=y(56)*T(30)*params(4)*(params(4)-1)*exp(y(50)*(params(4)-1));
g1(54,56)=params(4)*exp(y(50)*(params(4)-1))*T(30);
g1(55,26)=(-exp(y(26)));
g1(55,54)=params(22)*params(21)*(params(21)-1)*exp(y(54)*(params(21)-1));
g1(55,55)=1;
g1(56,7)=(-(exp(y(7))*(1-exp(y(11)))));
g1(56,32)=exp(y(32));
g1(56,34)=(-(params(7)*exp(y(34))));
g1(56,11)=(-(exp(y(7))*(-exp(y(11)))));
g1(57,17)=(-(exp(y(17))*(1-exp(y(54)))));
g1(57,52)=exp(y(52));
g1(57,53)=(-(params(23)*exp(y(53))));
g1(57,54)=T(109);
g1(58,6)=(-(exp(y(6))*(1-exp((-y(49)))*exp(y(10)))));
g1(58,31)=exp(y(31));
g1(58,33)=(-(params(7)*exp(y(33))));
g1(58,10)=T(117);
g1(58,49)=T(104);
g1(59,28)=(-(T(29)*params(4)*exp(y(28)*params(4))));
g1(59,9)=(-((1-params(7))*exp(y(9))));
g1(59,34)=exp(y(34));
g1(60,50)=(-(T(30)*params(4)*exp(y(50)*params(4))));
g1(60,18)=(-((1-params(23))*exp(y(18))));
g1(60,53)=exp(y(53));
g1(61,27)=(-(T(31)*params(4)*exp(y(27)*params(4))));
g1(61,8)=(-((1-params(7))*exp(y(8))));
g1(61,33)=exp(y(33));
g1(62,30)=exp(y(30));
g1(62,7)=(-(exp(y(7))*exp(y(11))));
g1(62,11)=(-(exp(y(7))*exp(y(11))));
g1(63,51)=exp(y(51));
g1(63,17)=T(108);
g1(63,54)=T(108);
g1(64,29)=exp(y(29));
g1(64,6)=T(115);
g1(64,10)=T(115);
g1(64,49)=T(103);
g1(65,29)=(-exp(y(29)));
g1(65,30)=(-exp(y(30)));
g1(65,40)=T(8);
g1(65,51)=(-exp(y(51)));
g1(66,49)=1;
g1(66,139)=(-1);
g1(67,16)=(-params(15));
g1(67,48)=1;
g1(67,140)=(-1);
g1(67,25)=(-params(16));
g1(68,10)=(-exp(y(10)));
g1(68,63)=exp(y(63));
g1(69,1)=1;
g1(69,26)=(-1);
g1(69,57)=1;
g1(70,3)=1;
g1(70,28)=(-1);
g1(70,58)=1;
g1(71,2)=1;
g1(71,27)=(-1);
g1(71,59)=1;
g1(72,5)=1;
g1(72,30)=(-1);
g1(72,60)=1;
g1(73,4)=1;
g1(73,29)=(-1);
g1(73,61)=1;
g1(74,12)=1;
g1(74,41)=(-1);
g1(74,62)=1;
g1(75,130)=(-1);
g1(75,99)=1;
g1(76,16)=(-1);
g1(76,100)=1;

end
